@extends('front.layout.master')
@section('style')
@endsection
@section('content')


<!-- Titlebar
================================================== -->
<!--<div id="titlebar">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h2> التسجيل والدخول </h2>
            </div>
        </div>
    </div>
</div>-->
<!-- Contact
================================================== -->

<!-- alert session -->
@if(session()->has('success'))
    <div class="success-msg">
        <i class="fa fa-check"></i>
        {{session()->get('success')}}
    </div>
@elseif(session()->has('error'))
    <div class="error-msg">
        <i class="fa fa-times-circle"></i>
        {{session()->get('error')}}
    </div>
@elseif(session()->has('warning'))
    <div class="warning-msg">
        <i class="fa fa-warning"></i>
        {{session()->get('warning')}}
    </div>
@endif
@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
<!-- alert session -->
<!-- Container -->
<div class="container">

    <div class="row">
    <div class="col-md-4 col-md-offset-4">

    <!--Tab -->
    <div class="my-account style-1 margin-top-5 margin-bottom-40">

        <ul class="tabs-nav">
            <li class=""><a href="#tab1">الدخول</a></li>
            <li><a href="#tab2">تسجيل حساب جديد</a></li>
        </ul>

        <div class="tabs-container alt">

            <!-- Login -->
            <div class="tab-content" id="tab1" style="display: none;">
                <form method="post" action="{{ route('login') }}" class="login">
                    @csrf
                    <p class="form-row form-row-wide {{ $errors->has('phone') ? ' has-error' : '' }}">
                        <label for="phone"> الجوال :
                            <i class="im im-icon-Male"></i>
                            <input type="text" class="input-text" name="phone" id="phone" value="{{ old('phone') }}" autofocus>
                            @if ($errors->has('phone'))
                                <span class="help-block">
                                            <strong>{{ $errors->first('phone') }}</strong>
                                        </span>
                            @endif
                        </label>
                    </p>

                    <p class="form-row form-row-wide {{ $errors->has('password') ? ' has-error' : '' }}">
                        <label for="password">الرقم السرى
                            <i class="im im-icon-Lock-2"></i>
                            <input class="input-text" type="password" name="password" id="password" />
                            @if ($errors->has('password'))
                                <span class="help-block">
                                            <strong>{{ $errors->first('password') }}</strong>
                                        </span>
                            @endif
                        </label>
                    </p>

                    <p class="form-row">
                        <input type="submit" class="button border margin-top-10" name="login" value="الدخول" />

                        <label for="rememberme" class="rememberme">
                        <input name="remember" type="checkbox" id="rememberme" value="1" /> تذكرنى </label>
                    </p>

                    <p class="lost_password">
                        <a href="{{ url('/password/reset') }}" >نسيت كلمه السر ؟</a>
                    </p>
                    
                </form>
            </div>

            <!-- Register -->
            <div class="tab-content" id="tab2" style="display: none;">

                <form method="post" action="{{route('register')}}" class="register">
                    @csrf
                <p class="form-row form-row-wide">
                    <label for="name">اسم المستخدم :
                        <i class="im im-icon-Male"></i>
                        <input type="text" class="input-text" name="name" id="name" value="" />
                        @if ($errors->has('name'))
                                <span class="help-block">
                                            <strong>{{ $errors->first('name') }}</strong>
                                        </span>
                            @endif
                    </label>
                </p>
                    
                <p class="form-row form-row-wide">
                    <label for="email2">البريد الالكترونى 
                        <i class="im im-icon-Mail"></i>
                        <input type="text" class="input-text" name="email" id="email2" />
                        @if ($errors->has('email'))
                            <span class="help-block">
                                <strong>{{ $errors->first('email') }}</strong>
                            </span>
                        @endif
                    </label>
                </p>
                    
                <p class="form-row form-row-wide">
                    <label for="phone">الجوال  
                        <i class="im im-icon-Phone"></i>
                        <input type="text" class="input-text" name="phone" id="phone" value="" />
                        @if ($errors->has('phone'))
                                <span class="help-block">
                                            <strong>{{ $errors->first('phone') }}</strong>
                                        </span>
                            @endif
                    </label>
                </p>

                <p class="form-row form-row-wide">
                    <label for="password1">كلمه السر :
                        <i class="im im-icon-Lock-2"></i>
                        <input class="input-text" type="password" name="password" id="password1"/>
                        @if ($errors->has('password'))
                                <span class="help-block">
                                            <strong>{{ $errors->first('password') }}</strong>
                                        </span>
                            @endif
                    </label>
                </p>

                <p class="form-row form-row-wide">
                    <label for="password2">اعاده كلمه السر :
                        <i class="im im-icon-Lock-2"></i>
                        <input class="input-text" type="password" name="password_confirmation" id="password2"/>
                    </label>
                </p>

                <p class="form-row">
                    <input type="submit" class="button border fw margin-top-10" name="register" value="التسجيل " />
                </p>

                </form>
            </div>

        </div>
    </div>



    </div>
    </div>

</div>
<!-- Container / End -->




@endsection
@section('script')
@endsection