@extends('admin.layout.app')
@section('style')

<!--venobox lightbox-->
<link rel="stylesheet" href="{{ asset('/adminto/assets/plugins/magnific-popup/dist/magnific-popup.css')}}"/>
@endsection
@section('content')
                <div class="row">
                    <div class="col-lg-12 table-custom">
                        <div class="title-page sub-header-title-custom">
                                <h5 style="color: inherit;"><a href="{{route('products.index')}}"><span> المعدات</span><i class="fa fa-angle-left" style="padding: 0 5px; color:inherit;"></i></a><span>  {{ $product->title}}  </span></h5>


                        </div>

                        <div class="panel panel-color card-box-v2 panel-tabs panel-success m-t-10">
                            <div class="panel-heading panel-heading-custom">
                                <ul class="nav nav-pills">
                                    <li class="active">
                                        <a href="#navpills-1" data-toggle="tab" aria-expanded="true">البيانات الأساسية</a>
                                    </li>
                                    {{-- <li class="">
                                        <a href="#navpills-2" data-toggle="tab" aria-expanded="false">المعدات</a>
                                    </li> --}}
                                    {{-- <li class="">
                                        <a href="#navpills-3" data-toggle="tab" aria-expanded="false">صور موقع العمل</a>
                                    </li> --}}
                                </ul>
                            </div>
                            <div class="panel-body">
                                <div class="tab-content">
                                    <div id="navpills-1" class="tab-pane    fade in active">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="item-name">
                                                    <span class="lbl" style="color:#C38555;"> اسم المعدة :</span>{{$product->title}}</div>
                                                <div class="img-cont">
                                                    @foreach ($product->images as $img)
                                                    <div class="img-wr">
                                                        <img src="{{$img->name ?? ''}}" alt="">
                                                    </div>
                                                    @endforeach
                                                </div>
                                                <div class="detals-cont">
                                                    <div class="item">
                                                        <span class="lbl"> رقم المعدة :</span>
                                                        <span class="val"> {{$product->product_number}}</span>
                                                    </div>
                                                    @if ($product->type == 'sale')
                                                    <div class="item">
                                                        <span class="lbl"> السعر :</span>
                                                        <span class="val"> {{$product->price}}</span>
                                                    </div>

                                                    @else
                                                    <div class="item">
                                                        <span class="lbl"> سعر الايجار الشهري :</span>
                                                        <span class="val"> {{$product->price}}</span>
                                                    </div>
                                                    <div class="item">
                                                        <span class="lbl"> سعر الايجار اليومي :</span>
                                                        <span class="val"> {{$product->daily_price}}</span>
                                                    </div>
                                                    <div class="item">
                                                        <span class="lbl"> سعر الايجار بالساعة :</span>
                                                        <span class="val"> {{$product->hour_price}}</span>
                                                    </div>

                                                    @endif
                                                    <div class="item">
                                                        <span class="lbl"> الكميه :</span>
                                                        <span class="val"> {{$product->quantity}}</span>
                                                    </div>
                                                    <div class="item">
                                                        <span class="lbl"> الوصف :</span>
                                                        <span class="val"> {{$product->description}}</span>
                                                    </div>
                                                    <div class="item">
                                                        <span class="lbl"> الاعمال التى تقوم بها :</span>
                                                        <span class="val"> {{$product->works}}</span>
                                                    </div>
                                                    <div class="item">
                                                        <span class="lbl"> المهمه :</span>
                                                        <span class="val"> {{$product->Mission->name_ar ?? ''}}</span>
                                                    </div>
                                                    <div class="item">
                                                        <span class="lbl"> الطراز :</span>
                                                        <span class="val"> {{$product->version}}</span>
                                                    </div>
                                                    <div class="item">
                                                        <span class="lbl"> رقم الهيكل :</span>
                                                        <span class="val"> {{$product->skeleton_no}}</span>
                                                    </div>
                                                    <div class="item">
                                                        <span class="lbl"> الشركه المصنعه :</span>
                                                        <span class="val"> {{$product->maker_company}}</span>
                                                    </div>
                                                    <div class="item">
                                                        <span class="lbl"> سنه الصنع :</span>
                                                        <span class="val"> {{$product->Year->name ?? ''}}</span>
                                                    </div>
                                                    <div class="item">
                                                        <span class="lbl"> اسم الفرع :</span>
                                                        <span class="val"> {{$product->Branch->name_ar ?? ''}}</span>
                                                    </div>
                                                    <div class="item">
                                                        <span class="lbl"> الموديل :</span>
                                                        <span class="val"> {{$product->model ?? ''}}</span>
                                                    </div>
                                                    <div class="item">
                                                        <span class="lbl"> نوع المعده :</span>
                                                        <span class="val"> {{__('words.'.$product->type)}}</span>
                                                    </div>
                                                </div>
                                            </div>


                                            {{-- <a href="assets/images/gallery/1.jpg" class="image-popup" >
                                                <img src="assets/images/gallery/1.jpg" class="thumb-img" alt="work-thumbnail">
                                            </a> --}}

                                        </div>
                                    </div>

                                    <div id="navpills-2" class="tab-pane fade">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="datatable-buttons table tab-pane-custom table-striped table-bordered"  style="width: 100%;">
                                                    <thead>
                                                        <tr>
                                                            <th># </th>
                                                            <th>المعدة  </th>
                                                            <th> الكمية </th>
                                                            <th> السعر </th>
                                                            <th> اجمالي السعر </th>
                                                           <th>تاريخ </th>
                                                        </tr>
                                                    </thead>

                                                    <tbody>


                                                    </tbody>
                                                </table>
                                            </div>

                                        </div>
                                    </div>
                                    <div id="navpills-3" class="tab-pane fade">
                                        <div class="row">
                                            @foreach($product->Files()->OrderBy('id', 'asc')->get() as $item)
                                                <div class="col-md-3">
                                                    <img src="{{getImage($item->image)}}" height="200" width="100%" />
                                                </div>
                                            @endforeach
                                            @foreach($product->extrFiles() as $item)
                                                <div class="col-md-3">
                                                    <img src="{{$item}}" height="200" width="100%" />
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->

                </div>
                <!-- end row -->
@endsection
@section('script')
<!-- Magnific popup -->
<script type="text/javascript" src="{{ asset('/adminto/assets/plugins/magnific-popup/dist/jquery.magnific-popup.min.js')}}"></script>

<script type="text/javascript" src="https://maps.google.com/maps/api/js?sensor=false&libraries=places&key=AIzaSyCUPprEbO25z-DXpDwe-0sA4FNwc7rI6Q0&language=ar"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $('.image-popup').magnificPopup({
            type: 'image',
            closeOnContentClick: true,
            mainClass: 'mfp-fade',
            gallery: {
                enabled: true,
                navigateByImgClick: true,
                preload: [0,1] // Will preload 0 - before current, and 1 after the current image
            }
        });
    });
    $(document).ready(function(){
        // gmaps
        $('.gmaps').each(function(i, obj) {
            //test
            console.log($( this ).attr('data-lat'));
            // console.log(i);
            initializeMap(obj, $( this ).attr('data-lat'), $( this ).attr('data-long'))
        });
    });
    function initializeMap(div, lat, long){
        // alert(3);
     var myLatlng = new google.maps.LatLng(parseFloat(lat),parseFloat(long));
     var myOptions = {
         zoom: 12,
         center: myLatlng,
         mapTypeId: google.maps.MapTypeId.ROADMAP
         }
      map = new google.maps.Map(div, myOptions);
      var marker = new google.maps.Marker({
          position: myLatlng,
          map: map,
      title:"location"
     });
}
</script>
@endsection
