@if (count($errors) > 0)
<div class="alert alert-danger">
  <ul>
    @foreach ($errors->all() as $error)
    <li>{{ $error }}</li>
    @endforeach
  </ul>
</div>
@endif
<div class="row">

<div class="col-md-6">
    <div class="form-horizontal">
        <div class="form-group">
            <label class="col-md-3 control-label">اسم المعده<span></span></label>
            <div class="col-md-9">
                {!! Form::text("title",null,['class'=>'form-control', 'placeholder' => " اسم المعده", 'required' => ''])!!}
            </div>
        </div>
    </div>
</div><!-- end col -->

<div class="col-md-6">
    <div class="form-horizontal">
        <div class="form-group">
            <label class="col-md-3 control-label">رقم المعدة<span></span></label>
            <div class="col-md-9">
                {!! Form::text("product_number",null,['class'=>'form-control', 'placeholder' => " رقم المعدة", 'required' => ''])!!}
            </div>
        </div>
    </div>
</div><!-- end col -->

<div class="col-md-6">
    <div class="form-horizontal">
        <div class="form-group">
            <label class="col-md-3 control-label">للايجار | للبيع <span></span></label>
            <div class="col-md-9">
                {!! Form::select("type",ProductType(),null,['class'=>"form-control select2 "])!!}
            </div>
        </div>
    </div>
</div><!-- end col -->

<div class="col-md-6">
    <div class="form-horizontal">
        <div class="form-group">
            <label class="col-md-3 control-label">(الموديل)النوع <span></span></label>
            <div class="col-md-9">
                {!! Form::text("model",null,['class'=>"form-control  "])!!}
            </div>
        </div>
    </div>
</div><!-- end col -->
<div class="col-md-6">
    <div class="form-horizontal">
        <div class="form-group">
            <label class="col-md-3 control-label">اللون <span></span></label>
            <div class="col-md-9">
                {!! Form::text("color",null,['class'=>"form-control  "])!!}
            </div>
        </div>
    </div>
</div><!-- end col -->
<div class="col-md-6">
    <div class="form-horizontal">
        <div class="form-group">
            <label class="col-md-3 control-label">المهمه <span></span></label>
            <div class="col-md-9">
                {!! Form::select("mission_id",MissionsList(),null,['class'=>"form-control select2 "])!!}
            </div>
        </div>
    </div>
</div><!-- end col -->
    <div class="col-md-6">
        <div class="form-horizontal">
            <div class="form-group">
                <label class="col-md-3 control-label"> الطراز <span></span></label>
                <div class="col-md-9">
                    {!! Form::text("version",null,['class'=>'form-control', 'placeholder' => "", 'required' => ''])!!}
                </div>
            </div>
        </div>
    </div><!-- end col -->
    <div class="col-md-6">
        <div class="form-horizontal">
            <div class="form-group">
                <label class="col-md-3 control-label"> رقم الهيكل <span></span></label>
                <div class="col-md-9">
                    {!! Form::text("skeleton_no",null,['class'=>'form-control', 'placeholder' => "", 'required' => ''])!!}
                </div>
            </div>
        </div>
    </div><!-- end col -->
    <div class="col-md-6">
        <div class="form-horizontal">
            <div class="form-group">
                <label class="col-md-3 control-label"> الشركة المصنعه <span></span></label>
                <div class="col-md-9">
                    {!! Form::text("maker_company",null,['class'=>'form-control', 'placeholder' => "", 'required' => ''])!!}
                </div>
            </div>
        </div>
    </div><!-- end col -->

<div class="col-md-6">
    <div class="form-horizontal">
        <div class="form-group">
            <label class="col-md-3 control-label">سنه الصنع  <span></span></label>
            <div class="col-md-9">
                {!! Form::select("year_id",Years(),null,['class'=>"form-control select2 "])!!}
            </div>
        </div>
    </div>
</div><!-- end col -->
<div class="col-md-6">
    <div class="form-horizontal">
        <div class="form-group">
            <label class="col-md-3 control-label rental"> السعر / شهري <span></span></label>
            <label class="col-md-3 control-label buy"> سعر البيع <span></span></label>
            <div class="col-md-9">
                {!! Form::number("price",null,['class'=>'form-control', 'placeholder' => "", 'required' => ''])!!}
            </div>
        </div>
        <div class="form-group rental">
            <label class="col-md-3 control-label"> السعر / يومي <span></span></label>
            <div class="col-md-9">
                {!! Form::number("daily_price",null,['class'=>'form-control', 'placeholder' => ""])!!}
            </div>
        </div>
        <div class="form-group rental">
            <label class="col-md-3 control-label"> السعر / الساعة <span></span></label>
            <div class="col-md-9">
                {!! Form::number("hour_price",null,['class'=>'form-control', 'placeholder' => ""])!!}
            </div>
        </div>
    </div>
</div><!-- end col -->
<div class="col-md-6">
    <div class="form-horizontal">
        <div class="form-group">
            <label class="col-md-3 control-label">القسم <span></span></label>
            <div class="col-md-9">
                {!! Form::select("category_id",CategoriesList(),null,['class'=>"form-control select2 "])!!}
            </div>
        </div>
    </div>
</div><!-- end col -->
<div class="col-md-6">
    <div class="form-horizontal">
        <div class="form-group">
            <label class="col-md-3 control-label"> عدد التوفر من المعدة فى المتجر  <span></span></label>
            <div class="col-md-9">
                {!! Form::number("quantity",null,['class'=>'form-control', 'placeholder' => "", 'required' => ''])!!}
            </div>
        </div>
    </div>
</div><!-- end col -->
<div class="col-md-6 rental">
    <div class="form-horizontal">
        <div class="form-group">
            <label class="col-md-3 control-label">عدد اللترات المستهلكه فى الساعة<span></span></label>
            <div class="col-md-9">
                {!! Form::number("gasoline",null,['class'=>'form-control', 'step' => ".01"])!!}
            </div>
        </div>
    </div>
</div>
<div class="col-md-6">
    <div class="form-horizontal">
        <div class="form-group">
            <label class="col-md-3 control-label" > صورة المنتج <span></span></label>
            <div class="col-md-9">
                {!! Form::file("images[]",['class'=>'form-control', 'placeholder' => "", 'multiple' => ''])!!}
                @if(isset($product))
                @foreach($product->Files()->get() as $item)
                    <div class="col-sm-3">
                        {!! FileHtmlContent($item->name)!!}
                        <center><a href="{{url('/ajax/file/delete/'.$item->id)}}" class="delete-file">حذف</a></center>
                    </div>
                @endforeach
            @endif
            </div>
        </div>
    </div>
</div><!-- end col -->
<div class="col-md-6">
    <div class="form-horizontal">
        <div class="form-group">
            <label class="col-md-3 control-label">  الوصف الفنى الكامل <span></span></label>
            <div class="col-md-9">
                {!! Form::textarea("description",null,['class'=>'form-control', 'placeholder' => "", 'required' => ''])!!}
            </div>
        </div>
    </div>
</div><!-- end col -->
<div class="col-md-6">
    <div class="form-horizontal">
        <div class="form-group">
            <label class="col-md-3 control-label">  الاعمال التى تقوم بها المعده <span></span></label>
            <div class="col-md-9">
                {!! Form::textarea("works",null,['class'=>'form-control', 'placeholder' => "", 'required' => ''])!!}
            </div>
        </div>
    </div>
</div><!-- end col -->
<div class="col-md-6">
    <div class="form-horizontal">
        <div class="form-group">
            <label class="col-md-3 control-label">الفرع <span></span></label>
            <div class="col-md-9">
                {!! Form::select("branch_id",Branchs(),null,['class'=>"form-control select2 "])!!}
            </div>
        </div>
    </div>
</div><!-- end col -->

<div class="col-md-6">
    <div class="form-horizontal">
        <div class="form-group">
            <label class="col-md-3 control-label">الحالة <span></span></label>
            <div class="col-md-9">
                <input type="checkbox" {!! (isset($product) && $product->active=='1')? 'checked':''   !!} name="active" value="1" data-plugin="switchery" onchange="switchaerych(this)" data-color="#00b19d"/>
            </div>

        </div>
    </div>
</div>





<div class="col-md-6 rental">
    @if (isset($product))
    <h4>مدن العمل للمعدة</h4>
        <table class="table bordered">
            <thead>
                <tr>
                    <th>المدينة</th>
                    <th>تكلفة النقل</th>
                    <th>العمليات</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($product->ProductCity()->get() as $item)
                    <tr style="text-align: center;">
                        <td>{{$item->City->name ?? ''}}</td>
                        <td>{{$item->cost}}</td>

                        <td>
                            <a href="#" data-route="{{route('product-cities.edit',$item->id)}}?product_id={{$product->id}}" data-toggle="modal" class="modal-ajax "
                                data-target="#myModal"><i class="fa fa-pencil  m-r-10" style="color: #188ae2;"></i> تعديل</a>
                            <a href="{{route('product-cities.destroy',$item)}}" id="delete-btn" ><i class="fa fa-trash-o m-r-10" style="color: #5b69bc;"></i> حذف</a>
                        </td>
                    </tr>
                @endforeach
                <tr>
                    <td colspan="3" style="text-align: center;">
                        <a href="#" class="btn blue modal-ajax" data-route="{{route('product-cities.create')}}?product_id={{$product->id}}" data-toggle="modal"
                            data-target="#myModal"><i class="fa fa-plus  m-r-10" style="color: #188ae2;"></i>
                            اضافة مدينة عمل للمعدة</a>
                    </td>
                </tr>
            </tbody>
        </table>

    @endif
</div><!-- end col -->



<div class="text-center col-md-12">
    <button type="submit" class="btn blue ">حفظ</button>
    <a href="{{url('/dashboard/products')}}" class="btn default cancel-button-panel">
        <i class="fa fa-times"></i>
        إلغاء الأمر
    </a>
</div>

</div>
