<!doctype html>
<html lang="en">
@php
    use Carbon\Carbon;
@endphp
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">


    <link rel="stylesheet" href="/bill/omierstyle.css">
    <title>omierbill</title>
</head>

<body onload="window.print()">
    <!---- header------------------>


    <div class="page">
        <div class="row1 flex">
            <div class="ar-box">
                <div>شركة الأومير للتجارة والمقاولات</div>
                <div>شركة سعودية مساهمة مقفلة</div>
                <div> سجل تجاري :1123000085</div>
            </div>
            <div class="img-box">
                <img src="/bill/logo.png" alt="logo">
            </div>
            <div class="e-box">
                <div>Alomaier Trading And Contracting Co.</div>
                <div> Saudi Closed Joint - stock company</div>
                <div> CR : 1123000085</div>
            </div>

        </div>
        <div class="text-center">اسم الفرع</div>
        <h5 class="title"><span class="border">فاتورة مبيعات</span></h5>
        <div class="flex-bt alig-center">
            <div class="box">
                <span class="lbl bold"> الرقم الضريبي : </span>
                <span class="val bold  f-18 "> {{getSettingValue('tax_number')}}</span>
            </div>
            <div class="box e-box">
                <div>print in</div>
                <div class="time">
                    {{Carbon::now()->format('d - m - Y h:i a')}}
                </div>
            </div>
        </div>
        <div class="border det-box bold">
            <div class="line flex-bt">
                <div class="item">
                    <span class="lbl">الرقم :</span>
                    <span class="val"> {{$order->id}}</span>
                </div>
                <div class="item">
                    <span class="lbl">التاريخ :</span>
                    <span class="val"> {{$order->created_at->format('d - m - Y')}}</span>
                </div>
                <div class="item w-22">
                    <span class="lbl">الحالة :</span>
                    <span class="val"> @lang('words.'.$order->status)</span>
                </div>
            </div>
            <div class="line2 ">
                <div class="item">
                    <span class="lbl">مكان العمل :</span>
                    <span class="val"> {{$order->address}}</span>
                </div>
            </div>
            <div class="line3 flex-bt">
                <div class="item">
                    <span class="lbl">المستودع :</span>
                    <span class="val"> {{$order->OrderItem()->first()->City->name_ar ?? ''}}</span>
                </div>
                <div class="item nowrap">
                    <span class="lbl">رقم امر المبيعات :</span>
                    <span class="val"> {{$order->id}}</span>
                </div>
                <div class="item nowrap w-22">
                    <span class="lbl">رقم الملف :</span>
                    <span class="val"> {{$order->user_id}}</span>
                </div>
            </div>
            <div class="line4 flex-bt">
                <div class="item">
                    <span class="lbl">العنوان :</span>
                    <span class="val"> {{$order->Branch->address ?? ''}}</span>
                </div>
                <div class="item nowrap w-22">
                    <span class="lbl">العملة :</span>
                    <span class="val"> ريال</span>
                </div>

            </div>
            <div class="line5 flex-bt">
                <div class="item">
                    <span class="lbl">الرقم الضريبي للعميل :</span>
                    <span class="val"> {{$order->User->tax_number ?? ''}}</span>
                </div>
                <div class="item nowrap w-22">
                    <span class="lbl">سعر الصرف :</span>
                    <span class="val"> 1 </span>
                </div>

            </div>
            <div class="line5 flex-bt">
                <div class="item">
                    <span class="lbl">عنوان العميل :</span>
                    <span class="val"> {{$order->User->address ?? ''}} </span>
                </div>

            </div>
            <div class="line5 flex-bt">
                <div class="item">
                    <span class="lbl"> مندوب المبيعات :</span>
                    <span class="val"> </span>
                </div>

            </div>


        </div>

        <div class="before-table border">الأصناف</div>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th scope="col">الرمز</th>
                    <th scope="col">اسم الصنف</th>
                    <th scope="col">الوحده</th>
                    <th scope="col">الكميه</th>
                    <th scope="col">السعر</th>
                    <th scope="col">القيمه</th>
                    <th scope="col">الخصم</th>
                    <th scope="col">الصافي</th>
                    <th scope="col">نسبة الضريبة</th>
                    <th scope="col">قيمة الضريبة</th>
                    <th scope="col">الصافي بعد الضريبة</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $i = 1;
                @endphp
                @foreach ($order->OrderItem()->get() as $item)
                    <tr>
                        <td>{{$item->Product->product_number ?? ''}}</td>
                        <td>{{$item->Product->title}}</td>
                        <td>معدة</td>
                        <td>{{$item->quantity}}</td>
                        <td>{{$item->price}}</td>
                        <td>{{$item->price  * $item->quantity}}</td>
                        <td>0</td>
                        <td>{{$item->price  * $item->quantity}}</td>
                        <td>{{getSettingValue('tax')}}</td>
                        <td>{{$tax = ($item->price  * $item->quantity) * ((float)getSettingValue('tax')/100)}}</td>
                        <td>{{$tax + ($item->price  * $item->quantity)}}</td>
                    </tr>
                    @php
                        $i++;
                    @endphp
                @endforeach
            </tbody>
        </table>


        <div class="last">
            <div class="flex alig-center">
                <span class="lbl bold"> اجمالي القيمة : </span>
                <span class="val bold  f-18 "> {{$order->original_total}}</span>
            </div>
            @if ($order->discount)
                <div class="flex alig-center">
                    <span class="lbl bold"> اجمالي الخصم : </span>
                    <span class="val bold  f-18 "> {{$order->discount}}</span>
                </div>
                <div class="flex-bt alig-center mx-500">
                    <div class="flex alig-center sub-box ">
                        <span class="lbl bold"> الصافي بعد الخصم : </span>
                        <span class="val bold  f-18 "> {{$order->original_total  - $order->discount}}</span>
                    </div>
                    <div class="flex alig-center sub-box ">
                        <span class="lbl bold"> خصم اضافى : </span>
                        <span class="val bold  f-18 "> 0</span>
                    </div>

                </div>

            @endif
            <div class="flex-bt alig-center mx-500">
                <div class="flex alig-center sub-box ">
                    <span class="lbl bold"> اجمالي الضريبة : </span>
                    <span class="val bold  f-18 "> {{$tax = $order->original_total * ((float)getSettingValue('tax')/100)}}</span>
                </div>
                <div class="flex alig-center sub-box ">
                    <span class="lbl bold"> الصافي بعد الضريبة : </span>
                    <span class="val bold  f-18 "> {{$order->total_price}}</span>
                </div>

            </div>
            <div class="total flex">
                {{-- <span> المجوع الكلي مكتوب بالحروف</span> --}}
            </div>
            <div class="flex seg">
                <span>جهز بواسطة </span>
                <span> مدير المبيعات</span>
                <span> الادارة المالية </span>
                <span> اعتماد</span>


            </div>



        </div>

        <footer>
            <p> هذة فاتورة يتم انشاؤها اليكترونيا ولا تتطلب توقيع او ختم المورد</p>
            <div class="flex alig-center">
                <div class="scan">
                    <img src="/bill/brc.png" alt="">

                </div>
                <div class="flex-bt alig-center">
                    <div class="ar-box">
                        <div class="bold"> شركة الاومير للتجارة </div>
                        <small> مكان اضافه بيانات الاتصال </small>
                    </div>
                    <div class="e-box">
                        <div>Alomaier Trading And Contracting Co.</div>
                        <small> {{getSettingValue('phone')}}</small>
                        <div class="bold"> {{getSettingValue('email')}}</div>

                    </div>

                </div>

            </div>
        </footer>





    </div>




</body>

</html>
